/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.compiler.PreparedTemplate;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.apache.commons.beanutils.MethodUtils;
import org.richfaces.skin.SkinFactory;
import org.xml.sax.SAXException;

public abstract class ElementBase
implements PreparedTemplate {
    private List childrens = new ArrayList();
    private Map breaks = new HashMap();
    protected ValueGetter valueGetter = new ValueGetter();
    private Object _value = null;
    private Object _default = null;
    private Object _context = null;
    private String _property = null;
    private String _skin;
    private String _baseSkin;
    private String _call = null;
    private PreparedTemplate parent;
    private ValueBinding _valueBinding;
    static /* synthetic */ Class class$org$ajax4jsf$renderkit$compiler$PreparedTemplate;

    public void encode(RendererBase renderer, FacesContext context, UIComponent component) throws IOException {
        this.encode(new TemplateContext(renderer, context, component));
    }

    public void encode(TemplateContext context, String breakPoint) throws IOException {
        if (this.breaks.containsKey(breakPoint)) {
            int start = (Integer)this.breaks.get(breakPoint);
            ListIterator iter = this.getChildren().listIterator(start);
            ((PreparedTemplate)iter.next()).encode(context, breakPoint);
            while (iter.hasNext()) {
                PreparedTemplate element = (PreparedTemplate)iter.next();
                element.encode(context);
            }
        } else {
            throw new FacesException(Messages.getMessage((String)"BREAKPOINT_NOT_REGISTERED_ERROR", (Object)breakPoint));
        }
        this.encodeEnd(context);
    }

    public void encode(TemplateContext context) throws IOException {
        this.encodeBegin(context);
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            PreparedTemplate element = (PreparedTemplate)iter.next();
            element.encode(context);
        }
        this.encodeEnd(context);
    }

    protected void encodeBegin(TemplateContext context) throws IOException {
    }

    protected void encodeEnd(TemplateContext context) throws IOException {
    }

    public List getChildren() {
        return this.childrens;
    }

    public void addChild(PreparedTemplate child) throws SAXException {
        Class[] allowedClasses = this.getAllowedClasses();
        for (int i = 0; i < allowedClasses.length; ++i) {
            if (!allowedClasses[i].isInstance(child)) continue;
            child.setParent(this);
            this.getChildren().add(child);
            return;
        }
        throw new SAXException(Messages.getMessage((String)"CHILD_NOT_ALLOWED_ERROR", (Object)child.getTag(), (Object)this.getTag()));
    }

    protected Class[] getAllowedClasses() {
        return new Class[]{class$org$ajax4jsf$renderkit$compiler$PreparedTemplate == null ? (class$org$ajax4jsf$renderkit$compiler$PreparedTemplate = ElementBase.class$("org.ajax4jsf.renderkit.compiler.PreparedTemplate")) : class$org$ajax4jsf$renderkit$compiler$PreparedTemplate};
    }

    public void setParent(PreparedTemplate parent) throws SAXException {
        this.parent = parent;
        if (parent instanceof ElementBase) {
            Iterator iter = this.breaks.keySet().iterator();
            while (iter.hasNext()) {
                ((ElementBase)parent).addBreakPoint((String)iter.next());
            }
        }
    }

    public void addBreakPoint(String name) {
        Integer num = new Integer(this.getChildren().size());
        this.breaks.put(name, num);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append(" [\n");
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            buf.append("    ").append(child.toString()).append(" ;\n");
        }
        buf.append("]\n");
        return buf.toString();
    }

    public Object getValue(TemplateContext context) {
        return this.valueGetter.getValue(context);
    }

    public String getString(TemplateContext context) throws FacesException {
        StringBuffer string = new StringBuffer();
        string.append(this.valueGetter.getStringOrDefault(context));
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ElementBase)) continue;
            ElementBase stringElement = (ElementBase)element;
            string.append(stringElement.getString(context));
        }
        return string.toString();
    }

    public void setValue(Object value) {
        String stringValue;
        if (value instanceof String && this.isValueReference(stringValue = (String)value)) {
            this._value = value;
            try {
                Application app = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
                this._valueBinding = app.createValueBinding(stringValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.valueGetter = new ValueGetter(){

                public Object getValue(TemplateContext context) {
                    if (null == ElementBase.this._valueBinding) {
                        Application app = context.getFacesContext().getApplication();
                        ElementBase.this._valueBinding = app.createValueBinding((String)ElementBase.this._value);
                    }
                    return ElementBase.this._valueBinding.getValue(context.getFacesContext());
                }
            };
            return;
        }
        this._value = value;
        this.valueGetter = new ValueGetter(){

            public Object getValue(TemplateContext context) {
                return ElementBase.this._value;
            }
        };
    }

    public Object getDefault() {
        return this._default;
    }

    public void setDefault(Object default1) {
        this._default = default1;
    }

    public void setProperty(String property) {
        this._property = property;
        this.valueGetter = new ValueGetter(){

            Object getValue(TemplateContext context) {
                Object value = context.getComponent().getAttributes().get(ElementBase.this._property);
                if (context.getRenderer().getUtils().isValidProperty(value)) {
                    return value;
                }
                return null;
            }
        };
    }

    public void setBaseSkin(String baseSkin) {
        this._baseSkin = baseSkin;
        this.valueGetter = new SkinValueGetter();
    }

    public void setSkin(String skin) {
        this._skin = skin;
        this.valueGetter = new SkinValueGetter();
    }

    public void setContext(Object context) {
        this._context = context;
        this.valueGetter = new ValueGetter(){

            Object getValue(TemplateContext context) {
                return context.getParameter(ElementBase.this._context);
            }
        };
    }

    public void setCall(String call) {
        this._call = call;
        this.valueGetter = new ValueGetter(){

            Object getValue(TemplateContext context) {
                try {
                    return MethodUtils.invokeMethod((Object)context.getRenderer(), (String)ElementBase.this._call, (Object[])new Object[]{context});
                }
                catch (Exception e) {
                    throw new FacesException(Messages.getMessage((String)"INVOKE_RENDERER_METHOD_ERROR", (Object)this.getClass().getName()), (Throwable)e);
                }
            }
        };
    }

    protected boolean isValueReference(String value) {
        int end;
        if (value == null) {
            return false;
        }
        int start = value.indexOf("#{");
        return start >= 0 && (end = value.lastIndexOf(125)) >= 0 && start < end;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ String getTag();

    protected class SkinValueGetter
    extends ValueGetter {
        protected SkinValueGetter() {
        }

        Object getValue(TemplateContext context) {
            FacesContext facesContext = context.getFacesContext();
            SkinFactory skinFactory = SkinFactory.getInstance();
            Object result = null;
            if (ElementBase.this._skin != null) {
                result = skinFactory.getSkin(facesContext).getParameter(facesContext, ElementBase.this._skin, ElementBase.this._default);
            } else if (ElementBase.this._baseSkin != null) {
                result = skinFactory.getSkin(facesContext).getParameter(facesContext, ElementBase.this._baseSkin, ElementBase.this._default);
            }
            if (ElementBase.this._baseSkin != null && (result == null || result.toString().length() == 0)) {
                result = skinFactory.getBaseSkin(facesContext).getParameter(facesContext, ElementBase.this._baseSkin, ElementBase.this._default);
            }
            return result;
        }
    }

    protected class ValueGetter {
        protected ValueGetter() {
        }

        Object getValue(TemplateContext context) {
            return null;
        }

        Object getValueOrDefault(TemplateContext context) {
            Object result = this.getValue(context);
            if (null == result) {
                result = ElementBase.this.getDefault();
            }
            return result;
        }

        String getStringOrDefault(TemplateContext context) {
            Object result = this.getValue(context);
            if ((null == result || result.toString().length() == 0) && null == (result = ElementBase.this.getDefault())) {
                result = "";
            }
            return result.toString();
        }
    }
}

