/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.xml.bind.JAXB;
import org.richfaces.javascript.LibraryFunction;
import org.richfaces.javascript.LibraryFunctionImplementation;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.validator.model.ClientSideScripts;
import org.richfaces.validator.model.Component;
import org.richfaces.validator.model.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientServiceConfigParser {
    private static final Logger LOG = RichfacesLogger.CONFIG.getLogger();

    private ClientServiceConfigParser() {
    }

    public static Map<Class<?>, LibraryFunction> parseConfig(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null == loader) {
            loader = ClientServiceConfigParser.class.getClassLoader();
        }
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        try {
            Enumeration<URL> resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                resultBuilder.putAll(ClientServiceConfigParser.parse(loader, url));
            }
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        return resultBuilder.build();
    }

    static Map<Class<?>, LibraryFunction> parse(ClassLoader loader, URL url) {
        HashMap result = Maps.newHashMap();
        try {
            ClientSideScripts clientSideScripts = (ClientSideScripts)JAXB.unmarshal((URL)url, ClientSideScripts.class);
            for (Component component : clientSideScripts.getComponent()) {
                try {
                    Class<?> componentClass = loader.loadClass(component.getType());
                    Iterable resources = Iterables.transform(component.getResource(), (Function)new Function<Resource, ResourceKey>(){

                        public ResourceKey apply(Resource from) {
                            return ResourceKey.create((String)from.getName(), (String)from.getLibrary());
                        }
                    });
                    LibraryFunctionImplementation function = new LibraryFunctionImplementation(component.getFunction(), resources);
                    result.put(componentClass, function);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn((CharSequence)("Found JavaScript function definition for class " + component.getType() + ", but that class is not presented"));
                }
            }
        }
        catch (Exception e) {
            throw new FacesException("Error parsing config file " + url, (Throwable)e);
        }
        return result;
    }
}

