/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryPlusOperations;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
EntityManagerFactoryInfo,
PersistenceExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceProvider persistenceProvider;
    private String persistenceUnitName;
    private final Map jpaPropertyMap = new HashMap();
    private Class<? extends EntityManagerFactory> entityManagerFactoryInterface;
    private Class<? extends EntityManager> entityManagerInterface;
    private JpaDialect jpaDialect;
    private JpaVendorAdapter jpaVendorAdapter;
    public EntityManagerFactory nativeEntityManagerFactory;
    private EntityManagerFactory entityManagerFactory;

    public void setPersistenceProviderClass(Class<? extends PersistenceProvider> persistenceProviderClass) {
        Assert.isAssignable(PersistenceProvider.class, persistenceProviderClass);
        this.persistenceProvider = (PersistenceProvider)BeanUtils.instantiateClass(persistenceProviderClass);
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    @Override
    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    @Override
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)jpaProperties, (Map)this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setEntityManagerFactoryInterface(Class<? extends EntityManagerFactory> emfInterface) {
        Assert.isAssignable(EntityManagerFactory.class, this.entityManagerInterface);
        this.entityManagerFactoryInterface = emfInterface;
    }

    public void setEntityManagerInterface(Class<? extends EntityManager> emInterface) {
        Assert.isAssignable(EntityManager.class, this.entityManagerInterface);
        this.entityManagerInterface = emInterface;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return this.entityManagerInterface;
    }

    public void setJpaDialect(JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect;
    }

    @Override
    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public void setJpaVendorAdapter(JpaVendorAdapter jpaVendorAdapter) {
        this.jpaVendorAdapter = jpaVendorAdapter;
    }

    public JpaVendorAdapter getJpaVendorAdapter() {
        return this.jpaVendorAdapter;
    }

    public final void afterPropertiesSet() throws PersistenceException {
        if (this.jpaVendorAdapter != null) {
            Map vendorPropertyMap;
            if (this.persistenceProvider == null) {
                this.persistenceProvider = this.jpaVendorAdapter.getPersistenceProvider();
            }
            if ((vendorPropertyMap = this.jpaVendorAdapter.getJpaPropertyMap()) != null) {
                for (Map.Entry entry : vendorPropertyMap.entrySet()) {
                    if (this.jpaPropertyMap.containsKey(entry.getKey())) continue;
                    this.jpaPropertyMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (this.entityManagerFactoryInterface == null) {
                this.entityManagerFactoryInterface = this.jpaVendorAdapter.getEntityManagerFactoryInterface();
            }
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = this.jpaVendorAdapter.getEntityManagerInterface();
            }
            if (this.jpaDialect == null) {
                this.jpaDialect = this.jpaVendorAdapter.getJpaDialect();
            }
        } else {
            if (this.entityManagerFactoryInterface == null) {
                this.entityManagerFactoryInterface = EntityManagerFactory.class;
            }
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = EntityManager.class;
            }
        }
        this.nativeEntityManagerFactory = this.createNativeEntityManagerFactory();
        if (this.nativeEntityManagerFactory == null) {
            throw new IllegalStateException("JPA PersistenceProvider returned null EntityManagerFactory - check your JPA provider setup!");
        }
        if (this.jpaVendorAdapter != null) {
            this.jpaVendorAdapter.postProcessEntityManagerFactory(this.nativeEntityManagerFactory);
        }
        this.entityManagerFactory = this.createEntityManagerFactoryProxy(this.nativeEntityManagerFactory);
    }

    protected EntityManagerFactory createEntityManagerFactoryProxy(EntityManagerFactory emf) {
        ClassLoader cl = this.getClass().getClassLoader();
        LinkedHashSet<Class<Object>> ifcs = new LinkedHashSet<Class<Object>>();
        if (this.entityManagerFactoryInterface != null) {
            ifcs.add(this.entityManagerFactoryInterface);
        } else {
            ifcs.addAll(ClassUtils.getAllInterfacesForClassAsSet(emf.getClass(), (ClassLoader)cl));
        }
        ifcs.add(EntityManagerFactoryInfo.class);
        EntityManagerFactoryPlusOperations plusOperations = null;
        if (this.getJpaDialect() != null && this.getJpaDialect().supportsEntityManagerFactoryPlusOperations()) {
            plusOperations = this.getJpaDialect().getEntityManagerFactoryPlusOperations(emf);
            ifcs.add(EntityManagerFactoryPlusOperations.class);
        }
        return (EntityManagerFactory)Proxy.newProxyInstance(cl, ifcs.toArray(new Class[ifcs.size()]), (InvocationHandler)new ManagedEntityManagerFactoryInvocationHandler(emf, this, plusOperations));
    }

    protected abstract EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException;

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.jpaDialect != null ? this.jpaDialect.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    @Override
    public EntityManagerFactory getNativeEntityManagerFactory() {
        return this.nativeEntityManagerFactory;
    }

    @Override
    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    public EntityManagerFactory getObject() {
        return this.entityManagerFactory;
    }

    public Class getObjectType() {
        return this.entityManagerFactory != null ? this.entityManagerFactory.getClass() : EntityManagerFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Closing JPA EntityManagerFactory for persistence unit '" + this.getPersistenceUnitName() + "'"));
        }
        this.entityManagerFactory.close();
    }

    private static class ManagedEntityManagerFactoryInvocationHandler
    implements InvocationHandler {
        private final EntityManagerFactory targetEntityManagerFactory;
        private final EntityManagerFactoryInfo entityManagerFactoryInfo;
        private final EntityManagerFactoryPlusOperations entityManagerFactoryPlusOperations;

        public ManagedEntityManagerFactoryInvocationHandler(EntityManagerFactory targetEmf, EntityManagerFactoryInfo emfInfo, EntityManagerFactoryPlusOperations entityManagerFactoryPlusOperations) {
            this.targetEntityManagerFactory = targetEmf;
            this.entityManagerFactoryInfo = emfInfo;
            this.entityManagerFactoryPlusOperations = entityManagerFactoryPlusOperations;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass().isAssignableFrom(EntityManagerFactoryInfo.class)) {
                    return method.invoke((Object)this.entityManagerFactoryInfo, args);
                }
                if (method.getDeclaringClass().equals(EntityManagerFactoryPlusOperations.class)) {
                    return method.invoke((Object)this.entityManagerFactoryPlusOperations, args);
                }
                Object retVal = method.invoke((Object)this.targetEntityManagerFactory, args);
                if (retVal instanceof EntityManager) {
                    EntityManager rawEntityManager = (EntityManager)retVal;
                    retVal = ExtendedEntityManagerCreator.createApplicationManagedEntityManager(rawEntityManager, this.entityManagerFactoryInfo);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

