/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.handler.PortletContentGenerator;
import org.springframework.webflow.context.portlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.portlet.FlowUrlHandler;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.portlet.FlowHandler;

public class FlowHandlerAdapter
extends PortletContentGenerator
implements HandlerAdapter,
InitializingBean {
    private static final String ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE = "actionRequestFlowException";
    private FlowExecutor flowExecutor;
    private FlowUrlHandler flowUrlHandler;

    public FlowHandlerAdapter() {
        this.setCacheSeconds(0);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowUrlHandler getFlowUrlHandler() {
        return this.flowUrlHandler;
    }

    public void setFlowUrlHandler(FlowUrlHandler urlHandler) {
        this.flowUrlHandler = urlHandler;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.flowExecutor, (String)"The FlowExecutor to execute flows is required");
        if (this.flowUrlHandler == null) {
            this.flowUrlHandler = new DefaultFlowUrlHandler();
        }
    }

    public boolean supports(Object handler) {
        return handler instanceof FlowHandler;
    }

    public ModelAndView handleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        FlowException e;
        FlowHandler flowHandler = (FlowHandler)handler;
        this.checkAndPrepare((PortletRequest)request, (MimeResponse)response);
        this.populateConveniencePortletProperties((PortletRequest)request);
        PortletSession session = request.getPortletSession(false);
        if (session != null && (e = (FlowException)session.getAttribute(ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE)) != null) {
            session.removeAttribute(ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE);
            return this.handleException(e, flowHandler, request, response);
        }
        String flowExecutionKey = this.flowUrlHandler.getFlowExecutionKey((PortletRequest)request);
        if (flowExecutionKey != null) {
            return this.resumeFlow(flowExecutionKey, flowHandler, request, response);
        }
        return this.startFlow(flowHandler, request, response);
    }

    public void handleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        block4: {
            FlowHandler flowHandler = (FlowHandler)handler;
            this.populateConveniencePortletProperties((PortletRequest)request);
            String flowExecutionKey = this.flowUrlHandler.getFlowExecutionKey((PortletRequest)request);
            PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
            try {
                FlowExecutionResult result = this.flowExecutor.resumeExecution(flowExecutionKey, context);
                if (result.isPaused()) {
                    this.flowUrlHandler.setFlowExecutionRenderParameter(result.getPausedKey(), response);
                    break block4;
                }
                if (result.isEnded()) {
                    this.handleFlowExecutionOutcome(result.getOutcome(), flowHandler, request, response);
                    break block4;
                }
                throw new IllegalStateException("Execution result should have been one of [paused] or [ended]");
            }
            catch (FlowException e) {
                request.getPortletSession().setAttribute(ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE, (Object)e);
            }
        }
    }

    public void handleEvent(EventRequest request, EventResponse response, Object handler) throws Exception {
        response.setRenderParameters(request);
    }

    public ModelAndView handleResource(ResourceRequest request, ResourceResponse response, Object handler) throws Exception {
        PortletRequestDispatcher rd;
        if (request.getResourceID() != null && (rd = this.getPortletContext().getRequestDispatcher(request.getResourceID())) != null) {
            rd.forward((PortletRequest)request, (PortletResponse)response);
        }
        return null;
    }

    protected void populateConveniencePortletProperties(PortletRequest request) {
        request.setAttribute("portletMode", (Object)request.getPortletMode().toString());
        request.setAttribute("portletWindowState", (Object)request.getWindowState().toString());
    }

    protected PortletExternalContext createPortletExternalContext(PortletRequest request, PortletResponse response) {
        return new PortletExternalContext(this.getPortletContext(), request, response);
    }

    protected MutableAttributeMap defaultCreateFlowExecutionInputMap(PortletRequest request) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap.size() == 0) {
            return null;
        }
        LocalAttributeMap inputMap = new LocalAttributeMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                inputMap.put(name, values[0]);
                continue;
            }
            inputMap.put(name, values);
        }
        return inputMap;
    }

    protected void defaultHandleExecutionOutcome(FlowExecutionOutcome outcome, FlowHandler flowHandler, ActionRequest request, ActionResponse response) throws PortletModeException {
    }

    protected ModelAndView defaultHandleException(FlowHandler flowHandler, FlowException e, RenderRequest request, RenderResponse response) {
        if (e instanceof NoSuchFlowExecutionException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Restarting a new execution of previously ended flow '" + flowHandler.getFlowId() + "'"));
            }
            this.startFlow(flowHandler, null, request, response);
            return null;
        }
        throw e;
    }

    private ModelAndView handleException(FlowException e, FlowHandler flowHandler, RenderRequest request, RenderResponse response) {
        String viewName = flowHandler.handleException(e, request, response);
        if (viewName != null) {
            return new ModelAndView(viewName);
        }
        return this.defaultHandleException(flowHandler, e, request, response);
    }

    private void handleFlowExecutionOutcome(FlowExecutionOutcome outcome, FlowHandler flowHandler, ActionRequest request, ActionResponse response) throws PortletModeException {
        boolean handled = flowHandler.handleExecutionOutcome(outcome, request, response);
        if (!handled) {
            this.defaultHandleExecutionOutcome(outcome, flowHandler, request, response);
        }
    }

    private ModelAndView startFlow(FlowHandler flowHandler, RenderRequest request, RenderResponse response) {
        MutableAttributeMap input = flowHandler.createExecutionInputMap(request);
        if (input == null) {
            input = this.defaultCreateFlowExecutionInputMap((PortletRequest)request);
        }
        return this.startFlow(flowHandler, input, request, response);
    }

    private ModelAndView startFlow(FlowHandler flowHandler, MutableAttributeMap input, RenderRequest request, RenderResponse response) {
        PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
        try {
            FlowExecutionResult result = this.flowExecutor.launchExecution(flowHandler.getFlowId(), input, context);
            if (result.isPaused()) {
                this.flowUrlHandler.setFlowExecutionInSession(result.getPausedKey(), request);
            }
            return null;
        }
        catch (FlowException e) {
            return this.handleException(e, flowHandler, request, response);
        }
    }

    private ModelAndView resumeFlow(String flowExecutionKey, FlowHandler flowHandler, RenderRequest request, RenderResponse response) throws IOException {
        PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
        try {
            this.flowExecutor.resumeExecution(flowExecutionKey, context);
            return null;
        }
        catch (FlowException e) {
            return this.handleException(e, flowHandler, request, response);
        }
    }
}

