/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ROI;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public class MaskOverviewProvider {
    private static final Logger LOGGER = Logging.getLogger((String)MaskOverviewProvider.class.toString());
    public static final String OVR_EXTENSION = ".ovr";
    private ImageReaderSpi readerSpi;
    private ImageReaderSpi overviewReaderSpi;
    private ImageInputStreamSpi streamSpi;
    private ImageInputStreamSpi overviewStreamSpi;
    private DatasetLayout layout;
    private URL fileURL;
    private URL ovrURL;
    private int numOverviews;
    private final boolean hasDatasetLayout;
    private int numInternalOverviews;
    private int numExternalOverviews;
    private int numInternalMasks;
    private int numExternalMasks;
    private int numExternalMasksOverviews;
    private boolean hasExternalMasks;
    private boolean hasExternalMasksOverviews;
    private URL maskURL;
    private ImageInputStreamSpi maskStreamSpi;
    private ImageReaderSpi maskReaderSpi;
    private URL maskOvrURL;
    private ImageInputStreamSpi maskOvrStreamSpi;
    private ImageReaderSpi maskOvrReaderSpi;

    public MaskOverviewProvider(DatasetLayout layout, File inputFile) throws IOException {
        this(layout, inputFile, (ImageReaderSpi)null);
    }

    public MaskOverviewProvider(DatasetLayout layout, File inputFile, ImageReaderSpi suggestedSPI) throws IOException {
        this(layout, inputFile, new SpiHelper(URLs.fileToUrl((File)inputFile), suggestedSPI));
    }

    public MaskOverviewProvider(DatasetLayout layout, URL inputFile) throws IOException {
        this(layout, inputFile, (ImageReaderSpi)null);
    }

    public MaskOverviewProvider(DatasetLayout layout, URL inputFile, ImageReaderSpi suggestedSPI) throws IOException {
        this(layout, inputFile, new SpiHelper(inputFile, suggestedSPI));
    }

    public MaskOverviewProvider(DatasetLayout layout, File inputFile, SpiHelper spiProvider) throws IOException {
        this(layout, URLs.fileToUrl((File)inputFile), spiProvider);
    }

    public MaskOverviewProvider(DatasetLayout layout, URL inputFile, SpiHelper spiProvider) throws IOException {
        ImageReaderSpi suggestedSPI = spiProvider.getSuggestedSpi();
        ImageInputStreamSpi suggestedStreamSPI = spiProvider.getSuggestedStreamSpi();
        this.readerSpi = spiProvider.getReaderSpi();
        this.streamSpi = spiProvider.getStreamSpi();
        this.fileURL = spiProvider.getFileURL();
        this.layout = layout;
        this.ovrURL = new URL(inputFile.toString() + OVR_EXTENSION);
        boolean bl = this.hasDatasetLayout = layout != null;
        if (this.hasDatasetLayout && layout.getExternalOverviews() != null) {
            this.ovrURL = URLs.fileToUrl((File)layout.getExternalOverviews());
        }
        this.overviewStreamSpi = suggestedStreamSPI == null ? MaskOverviewProvider.getInputStreamSPIFromURL(this.ovrURL) : suggestedStreamSPI;
        ImageInputStream ovrStream = null;
        boolean hasExternalOverviews = false;
        try {
            ovrStream = this.overviewStreamSpi.createInputStreamInstance(this.ovrURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            if (ovrStream == null) {
                this.overviewStreamSpi = this.streamSpi;
                this.overviewReaderSpi = this.readerSpi;
            } else {
                this.overviewReaderSpi = MaskOverviewProvider.getReaderSpiFromStream(null, ovrStream);
                hasExternalOverviews = true;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + this.ovrURL, e);
            }
            throw new IllegalArgumentException(e);
        }
        finally {
            block46: {
                if (ovrStream != null) {
                    try {
                        ovrStream.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block46;
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        int numOverviews = 0;
        if (this.hasDatasetLayout) {
            this.numInternalOverviews = layout.getNumInternalOverviews();
            this.numExternalOverviews = layout.getNumExternalOverviews() > 0 ? layout.getNumExternalOverviews() : 0;
        } else if (!spiProvider.isMultidim()) {
            this.numInternalOverviews = this.getNumOverviews(inputFile, this.streamSpi, this.readerSpi);
            this.numExternalOverviews = 0;
            if (hasExternalOverviews) {
                this.numExternalOverviews = this.getNumOverviews(this.ovrURL, this.overviewStreamSpi, this.overviewReaderSpi) + 1;
            }
        }
        numOverviews = this.numInternalOverviews + this.numExternalOverviews;
        if (numOverviews < 0) {
            numOverviews = 0;
        }
        this.numOverviews = numOverviews;
        if (layout != null) {
            this.numInternalMasks = layout.getNumInternalMasks();
            this.numExternalMasks = layout.getNumExternalMasks() > 0 ? layout.getNumExternalMasks() : 0;
            this.numExternalMasksOverviews = layout.getNumExternalMaskOverviews() > 0 ? layout.getNumExternalMaskOverviews() : 0;
            this.hasExternalMasks = this.numExternalMasks > 0;
            boolean bl2 = this.hasExternalMasksOverviews = this.hasExternalMasks && this.numExternalMasksOverviews > 0;
            if (this.hasExternalMasks) {
                this.maskURL = URLs.fileToUrl((File)layout.getExternalMasks());
                this.maskStreamSpi = MaskOverviewProvider.getInputStreamSPIFromURL(this.maskURL);
                ImageInputStream maskStream = null;
                try {
                    maskStream = this.maskStreamSpi.createInputStreamInstance(this.maskURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                    this.maskReaderSpi = MaskOverviewProvider.getReaderSpiFromStream(suggestedSPI, maskStream);
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + this.maskURL, e);
                    }
                    throw new IllegalArgumentException(e);
                }
                finally {
                    block48: {
                        if (maskStream != null) {
                            try {
                                maskStream.close();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.SEVERE)) break block48;
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                    }
                }
                if (this.hasExternalMasksOverviews) {
                    this.maskOvrURL = URLs.fileToUrl((File)layout.getExternalMaskOverviews());
                    this.maskOvrStreamSpi = MaskOverviewProvider.getInputStreamSPIFromURL(this.maskOvrURL);
                    ImageInputStream maskOvrStream = null;
                    try {
                        maskOvrStream = this.maskOvrStreamSpi.createInputStreamInstance(this.maskOvrURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                        this.maskOvrReaderSpi = MaskOverviewProvider.getReaderSpiFromStream(suggestedSPI, maskOvrStream);
                    }
                    catch (Exception e) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + this.maskOvrURL, e);
                        }
                        throw new IllegalArgumentException(e);
                    }
                    finally {
                        block49: {
                            if (maskOvrStream != null) {
                                try {
                                    maskOvrStream.close();
                                }
                                catch (Exception e) {
                                    if (!LOGGER.isLoggable(Level.SEVERE)) break block49;
                                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
                this.maskOvrStreamSpi = this.maskStreamSpi;
                this.maskOvrReaderSpi = this.maskReaderSpi;
            } else {
                this.maskStreamSpi = this.streamSpi;
                this.maskReaderSpi = this.readerSpi;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumOverviews(URL inputFile, ImageInputStreamSpi streamSpi, ImageReaderSpi readerSpi) {
        ImageInputStream imageStream = null;
        ImageReader reader = null;
        try {
            imageStream = streamSpi.createInputStreamInstance(inputFile, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            reader = readerSpi.createReaderInstance();
            reader.setInput(imageStream, false, false);
            int numOverviews = reader.getNumImages(true) - 1;
            return numOverviews;
        }
        catch (Exception e) {
            if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException(e);
            LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + inputFile, e);
            throw new IllegalArgumentException(e);
        }
        finally {
            if (imageStream != null) {
                try {
                    imageStream.close();
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
            }
        }
    }

    public int getOverviewIndex(int imageIndex) {
        if (this.numExternalOverviews > 0 && imageIndex >= this.numInternalOverviews + 1) {
            return imageIndex - this.numInternalOverviews - 1;
        }
        if (this.layout != null) {
            return this.layout.getInternalOverviewImageIndex(imageIndex);
        }
        return imageIndex;
    }

    public MaskInfo getMaskInfo(int imageIndex, Rectangle imageBounds, ImageReadParam originalParams) {
        MaskInfo info = null;
        if (this.numInternalMasks + this.numExternalMasks > 0) {
            info = new MaskInfo();
            ImageReadParam readParam = new ImageReadParam();
            readParam.setSourceSubsampling(originalParams.getSourceXSubsampling(), originalParams.getSourceYSubsampling(), originalParams.getSubsamplingXOffset(), originalParams.getSubsamplingYOffset());
            Rectangle sourceRegion = imageBounds;
            if (originalParams.getSourceRegion() != null) {
                sourceRegion = originalParams.getSourceRegion();
            }
            readParam.setSourceRegion(sourceRegion);
            info.readParameters = readParam;
            if (imageIndex > 0) {
                if (imageIndex < this.numInternalMasks) {
                    info.file = URLs.urlToFile((URL)this.fileURL);
                    info.readerSpi = this.readerSpi;
                    info.streamSpi = this.streamSpi;
                    info.index = imageIndex != 0 ? this.layout.getInternalMaskImageIndex(imageIndex) - 1 : this.layout.getInternalMaskImageIndex(imageIndex);
                } else if (this.hasExternalMasks) {
                    if (imageIndex < this.numExternalMasks) {
                        info.file = URLs.urlToFile((URL)this.maskURL);
                        info.readerSpi = this.maskReaderSpi;
                        info.streamSpi = this.maskStreamSpi;
                        info.index = imageIndex;
                    } else if (imageIndex < this.numExternalMasks + this.numExternalMasksOverviews) {
                        info.file = URLs.urlToFile((URL)this.maskOvrURL);
                        info.readerSpi = this.maskOvrReaderSpi;
                        info.streamSpi = this.maskOvrStreamSpi;
                        info.index = imageIndex - this.numExternalMasks;
                    } else if (this.numExternalMasksOverviews > 0) {
                        info.file = URLs.urlToFile((URL)this.maskOvrURL);
                        info.readerSpi = this.maskOvrReaderSpi;
                        info.streamSpi = this.maskOvrStreamSpi;
                        info.index = this.numExternalMasksOverviews - 1;
                    } else {
                        info.file = URLs.urlToFile((URL)this.maskURL);
                        info.readerSpi = this.maskReaderSpi;
                        info.streamSpi = this.maskStreamSpi;
                        info.index = this.numExternalMasks - 1;
                    }
                } else {
                    info.file = URLs.urlToFile((URL)this.fileURL);
                    info.readerSpi = this.readerSpi;
                    info.streamSpi = this.streamSpi;
                    info.index = this.numInternalMasks - 1;
                }
            } else if (imageIndex == 0) {
                if (this.numInternalMasks == 0 && this.hasExternalMasks) {
                    info.file = URLs.urlToFile((URL)this.maskURL);
                    info.readerSpi = this.maskReaderSpi;
                    info.streamSpi = this.maskStreamSpi;
                    info.index = 0;
                } else if (this.numInternalMasks > 0) {
                    info.file = URLs.urlToFile((URL)this.fileURL);
                    info.readerSpi = this.readerSpi;
                    info.streamSpi = this.streamSpi;
                    info.index = this.layout.getInternalMaskImageIndex(0);
                }
            }
        }
        return info;
    }

    public boolean hasMaskIndexForOverview(int imageIndex) {
        if (imageIndex > 0) {
            if (imageIndex < this.numInternalMasks) {
                return true;
            }
            if (this.hasExternalMasks && imageIndex <= this.numExternalMasks + this.numExternalMasksOverviews - 1) {
                return true;
            }
        } else if (imageIndex == 0 && this.numInternalMasks > 0 || this.hasExternalMasks) {
            return true;
        }
        return false;
    }

    public boolean isExternalOverview(int imageIndex) {
        if (this.numExternalOverviews <= 0) {
            return false;
        }
        return imageIndex > this.numInternalOverviews;
    }

    public boolean isExternalMask(int imageIndex) {
        if (this.numExternalMasks <= 0) {
            return false;
        }
        return this.hasExternalMasks && imageIndex > (this.numInternalMasks > 0 ? this.numInternalMasks + 1 : 0);
    }

    public boolean isExternalMaskOverviews(int imageIndex) {
        if (this.numExternalMasksOverviews <= 0) {
            return false;
        }
        return this.isExternalMask(imageIndex) && this.hasExternalMasksOverviews && imageIndex > (this.numInternalMasks > 0 ? this.numInternalMasks + this.numExternalMasks + 2 : this.numExternalMasks + 1);
    }

    public boolean hasExternalMasks() {
        return this.hasExternalMasks;
    }

    public boolean hasExternalMasksOverviews() {
        return this.hasExternalMasksOverviews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double[][] getOverviewResolutions(double span0, double span1) {
        double[][] overviewsResolution = null;
        if (this.numOverviews <= 0) return overviewsResolution;
        ImageInputStream stream = null;
        ImageInputStream streamOvr = null;
        ImageReader reader = null;
        ImageReader readerOvr = null;
        try {
            stream = this.getInputStreamSpi().createInputStreamInstance(this.fileURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            reader = this.getImageReaderSpi().createReaderInstance();
            reader.setInput(stream, false, false);
            if (this.ovrURL != null) {
                streamOvr = this.getExternalOverviewInputStreamSpi().createInputStreamInstance(this.ovrURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                readerOvr = this.getExternalOverviewReaderSpi().createReaderInstance();
                readerOvr.setInput(streamOvr, false, false);
            }
            overviewsResolution = new double[this.numOverviews][2];
            for (int i = 0; i < this.numOverviews; ++i) {
                int index;
                if (this.numExternalOverviews > 0 && i >= this.numInternalOverviews) {
                    index = i - this.numInternalOverviews;
                    overviewsResolution[i][0] = span0 / (double)readerOvr.getWidth(index);
                    overviewsResolution[i][1] = span1 / (double)readerOvr.getHeight(index);
                    continue;
                }
                index = this.hasDatasetLayout ? this.layout.getInternalOverviewImageIndex(i + 1) : i + 1;
                overviewsResolution[i][0] = span0 / (double)reader.getWidth(index);
                overviewsResolution[i][1] = span1 / (double)reader.getHeight(index);
            }
            return overviewsResolution;
        }
        catch (Exception e) {
            if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException(e);
            LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + this.fileURL, e);
            throw new IllegalArgumentException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
            }
            if (streamOvr != null) {
                try {
                    streamOvr.close();
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                finally {
                    if (readerOvr != null) {
                        readerOvr.dispose();
                    }
                }
            }
        }
    }

    public ImageReaderSpi getExternalOverviewReaderSpi() {
        return this.overviewReaderSpi;
    }

    public ImageReaderSpi getImageReaderSpi() {
        return this.readerSpi;
    }

    public ImageInputStreamSpi getExternalOverviewInputStreamSpi() {
        return this.overviewStreamSpi;
    }

    public ImageInputStreamSpi getInputStreamSpi() {
        return this.streamSpi;
    }

    public ImageInputStreamSpi getMaskStreamSpi() {
        return this.maskStreamSpi;
    }

    public ImageReaderSpi getMaskReaderSpi() {
        return this.maskReaderSpi;
    }

    public ImageInputStreamSpi getMaskOvrStreamSpi() {
        return this.maskOvrStreamSpi;
    }

    public ImageReaderSpi getMaskOvrReaderSpi() {
        return this.maskOvrReaderSpi;
    }

    public DatasetLayout getLayout() {
        return this.layout;
    }

    public int getNumOverviews() {
        return this.numOverviews;
    }

    public int getNumInternalOverviews() {
        return this.numInternalOverviews;
    }

    public int getNumExternalOverviews() {
        return this.numExternalOverviews;
    }

    public int getNumInternalMasks() {
        return this.numInternalMasks;
    }

    public int getNumExternalMasks() {
        return this.numExternalMasks;
    }

    public int getNumExternalMasksOverviews() {
        return this.numExternalMasksOverviews;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public URL getOvrURL() {
        return this.ovrURL;
    }

    public URL getMaskURL() {
        return this.maskURL;
    }

    public URL getMaskOvrURL() {
        return this.maskOvrURL;
    }

    public static ImageInputStreamSpi getInputStreamSPIFromURL(URL fileURL) throws IOException {
        ImageInputStreamSpi streamSPI = ImageIOExt.getImageInputStreamSPI(fileURL, true);
        if (streamSPI == null) {
            File file = URLs.urlToFile((URL)fileURL);
            if (file != null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, file.getCanonicalPath());
            }
            throw new IllegalArgumentException("Unable to get an input stream for the provided source " + fileURL.toString());
        }
        return streamSPI;
    }

    public static ImageReaderSpi getReaderSpiFromStream(ImageReaderSpi suggestedSPI, ImageInputStream inStream) throws IOException {
        ImageReaderSpi readerSPI = null;
        inStream.mark();
        if (suggestedSPI != null && suggestedSPI.canDecodeInput(inStream)) {
            readerSPI = suggestedSPI;
            inStream.reset();
        } else {
            inStream.mark();
            ImageReader reader = ImageIOExt.getImageioReader(inStream);
            if (reader != null) {
                readerSPI = reader.getOriginatingProvider();
            }
            inStream.reset();
        }
        return readerSPI;
    }

    public static ROI scaleROI(RenderedImage roiRaster, Rectangle bounds) {
        if (roiRaster == null) {
            return null;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        double scaleX = (double)w / (1.0 * (double)roiRaster.getWidth());
        double scaleY = (double)h / (1.0 * (double)roiRaster.getHeight());
        AffineTransform tr = AffineTransform.getScaleInstance(scaleX, scaleY);
        int transX = x;
        int transY = y;
        tr.concatenate(AffineTransform.getTranslateInstance(transX, transY));
        if (!tr.isIdentity()) {
            LOGGER.fine("Scaling ROI");
        }
        return new ImageWorker(roiRaster).affine(tr, null, null).binarize(1.0).getImageAsROI();
    }

    public static class SpiHelper {
        private static final Set<String> MULTIDIM_SERVICE_PROVIDERS = new HashSet<String>();
        private ImageReaderSpi suggestedSpi;
        private ImageReaderSpi readerSpi;
        private ImageInputStreamSpi suggestedStreamSpi;
        private ImageInputStreamSpi streamSpi;
        private URL fileURL;
        private boolean isMultidim;

        public SpiHelper(URL inputFile, ImageReaderSpi suggestedSPI) throws IOException {
            this(inputFile, suggestedSPI, null);
        }

        public SpiHelper(URL inputFile, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedStreamSpi) throws IOException {
            this.suggestedSpi = suggestedSPI;
            this.fileURL = inputFile;
            this.suggestedStreamSpi = suggestedStreamSpi;
            this.streamSpi = suggestedStreamSpi == null ? MaskOverviewProvider.getInputStreamSPIFromURL(this.fileURL) : suggestedStreamSpi;
            ImageInputStream stream = null;
            try {
                stream = this.streamSpi.createInputStreamInstance(this.fileURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                this.readerSpi = MaskOverviewProvider.getReaderSpiFromStream(suggestedSPI, stream);
                this.isMultidim = this.readerSpi != null && MULTIDIM_SERVICE_PROVIDERS.contains(this.readerSpi.getClass().getName());
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + inputFile, e);
                }
                throw new IllegalArgumentException(e);
            }
            finally {
                block12: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
            }
        }

        public boolean isMultidim() {
            return this.isMultidim;
        }

        public ImageReaderSpi getReaderSpi() {
            return this.readerSpi;
        }

        public ImageInputStreamSpi getStreamSpi() {
            return this.streamSpi;
        }

        public URL getFileURL() {
            return this.fileURL;
        }

        public ImageReaderSpi getSuggestedSpi() {
            return this.suggestedSpi;
        }

        public ImageInputStreamSpi getSuggestedStreamSpi() {
            return this.suggestedStreamSpi;
        }

        static {
            MULTIDIM_SERVICE_PROVIDERS.add("org.geotools.imageio.netcdf.NetCDFImageReaderSpi");
        }
    }

    public static class MaskInfo {
        public File file;
        public int index;
        public ImageReadParam readParameters;
        public ImageReaderSpi readerSpi;
        public ImageInputStreamSpi streamSpi;
    }
}

