/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.lang.reflect.Method;
import java.util.Date;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDateConverterFactory
implements ConverterFactory {
    OracleDateConverter converter = new OracleDateConverter();
    static final Class ORA_DATE;
    static final Class ORA_TIMESTAMP;
    static final Method ORA_DATE_DVALUE;
    static final Method ORA_DATE_TSVALUE;
    static final Method ORA_TS_DVALUE;
    static final Method ORA_TS_TSVALUE;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (!Date.class.isAssignableFrom(target)) {
            return null;
        }
        if (!ORA_TIMESTAMP.isAssignableFrom(source) && !ORA_DATE.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    static {
        try {
            ORA_DATE = Class.forName("oracle.sql.DATE");
            ORA_DATE_DVALUE = ORA_DATE.getMethod("dateValue", new Class[0]);
            ORA_DATE_TSVALUE = ORA_DATE.getMethod("timestampValue", new Class[0]);
            ORA_TIMESTAMP = Class.forName("oracle.sql.TIMESTAMP");
            ORA_TS_DVALUE = ORA_TIMESTAMP.getMethod("dateValue", new Class[0]);
            ORA_TS_TSVALUE = ORA_TIMESTAMP.getMethod("timestampValue", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize the oracle date converter", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OracleDateConverter
    implements Converter {
        OracleDateConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (ORA_TIMESTAMP.isInstance(source)) {
                if (java.sql.Date.class.isAssignableFrom(target)) {
                    return (T)ORA_TS_DVALUE.invoke(source, new Object[0]);
                }
                return (T)ORA_TS_TSVALUE.invoke(source, new Object[0]);
            }
            if (java.sql.Date.class.isAssignableFrom(target)) {
                return (T)ORA_DATE_DVALUE.invoke(source, new Object[0]);
            }
            return (T)ORA_DATE_TSVALUE.invoke(source, new Object[0]);
        }
    }
}

