/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.oracle.OracleDialect;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleFilterToSQL
extends PreparedFilterToSQL {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.SQLEncoderOracle");
    private static final Map<Class, String> SDO_RELATE_MASK_MAP = new HashMap<Class, String>(){
        {
            this.put(Contains.class, "contains");
            this.put(Crosses.class, "overlapbdydisjoint");
            this.put(Equals.class, "equal");
            this.put(Overlaps.class, "overlapbdyintersect");
            this.put(Touches.class, "touch");
            this.put(Within.class, "inside");
            this.put(Disjoint.class, "disjoint");
            this.put(BBOX.class, "anyinteract");
            this.put(Intersects.class, "anyinteract");
        }
    };
    private static final Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    private static final Map<String, String> INVERSE_OPERATOR_MAP = new HashMap<String, String>(){
        {
            this.put("contains", "inside");
            this.put("inside", "contains");
            this.put("overlapbdydisjoint", "overlapbdydisjoint");
            this.put("overlapbdyintersect", "overlapbdyintersect");
            this.put("touch", "touch");
            this.put("equal", "equal");
            this.put("anyinteract", "anyinteract");
            this.put("disjoint", "disjoint");
        }
    };
    protected boolean looseBBOXEnabled;

    public OracleFilterToSQL(PreparedStatementSQLDialect dialect) {
        super(dialect);
        this.setSqlNameEscape("\"");
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        return caps;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            Geometry result;
            Geometry eval = (Geometry)geometry.evaluate((Object)filter, Geometry.class);
            if (this.dialect != null && ((OracleDialect)this.dialect).isGeodeticSrid(this.currentSRID) && !WORLD.contains(eval.getEnvelopeInternal()) && (result = eval.intersection((Geometry)JTS.toGeometry((Envelope)WORLD))) != null && !result.isEmpty()) {
                if (result instanceof GeometryCollection) {
                    result = this.distillSameTypeGeometries((GeometryCollection)result, eval);
                }
                geometry = new FilterFactoryImpl().createLiteralExpression((Object)result);
            }
            if (filter instanceof Beyond || filter instanceof DWithin) {
                this.doSDODistance(filter, property, geometry, extraData);
            } else if (filter instanceof BBOX && this.looseBBOXEnabled) {
                this.doSDOFilter((Filter)filter, property, geometry, extraData);
            } else {
                this.doSDORelate((Filter)filter, property, geometry, swapped, extraData);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
        return extraData;
    }

    protected Geometry distillSameTypeGeometries(GeometryCollection coll, Geometry original) {
        if (original instanceof Polygon || original instanceof MultiPolygon) {
            ArrayList polys = new ArrayList();
            this.accumulateGeometries(polys, (Geometry)coll, Polygon.class);
            return original.getFactory().createMultiPolygon(polys.toArray(new Polygon[polys.size()]));
        }
        if (original instanceof LineString || original instanceof MultiLineString) {
            ArrayList ls = new ArrayList();
            this.accumulateGeometries(ls, (Geometry)coll, LineString.class);
            return original.getFactory().createMultiLineString(ls.toArray(new LineString[ls.size()]));
        }
        if (original instanceof Point || original instanceof MultiPoint) {
            ArrayList points = new ArrayList();
            this.accumulateGeometries(points, (Geometry)coll, LineString.class);
            return original.getFactory().createMultiPoint(points.toArray(new Point[points.size()]));
        }
        return original;
    }

    protected <T> void accumulateGeometries(List<T> collection, Geometry g, Class<? extends T> target) {
        if (target.isInstance(g)) {
            collection.add(g);
        } else if (g instanceof GeometryCollection) {
            GeometryCollection coll = (GeometryCollection)g;
            for (int i = 0; i < coll.getNumGeometries(); ++i) {
                this.accumulateGeometries(collection, coll.getGeometryN(i), target);
            }
        }
    }

    protected void doSDOFilter(Filter filter, PropertyName property, Literal geometry, Object extraData) throws IOException {
        this.out.write("SDO_FILTER(");
        property.accept((ExpressionVisitor)this, extraData);
        this.out.write(", ");
        geometry.accept((ExpressionVisitor)this, extraData);
        this.out.write(") = 'TRUE' ");
    }

    protected void doSDORelate(Filter filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        String mask = null;
        for (Class filterClass : SDO_RELATE_MASK_MAP.keySet()) {
            if (!filterClass.isAssignableFrom(filter.getClass())) continue;
            mask = SDO_RELATE_MASK_MAP.get(filterClass);
        }
        if (mask == null) {
            throw new IllegalArgumentException("Cannot encode filter " + filter.getClass() + " into a SDO_RELATE");
        }
        if (swapped) {
            mask = INVERSE_OPERATOR_MAP.get(mask);
        }
        this.out.write("SDO_RELATE(");
        property.accept((ExpressionVisitor)this, extraData);
        this.out.write(", ");
        geometry.accept((ExpressionVisitor)this, extraData);
        if (filter instanceof Disjoint) {
            this.out.write(", 'mask=" + mask + " querytype=WINDOW') <> 'FALSE' ");
        } else {
            this.out.write(", 'mask=" + mask + " querytype=WINDOW') = 'TRUE' ");
        }
    }

    protected void doSDODistance(BinarySpatialOperator filter, PropertyName property, Literal geometry, Object extraData) throws IOException {
        double distance = ((DistanceBufferOperator)filter).getDistance();
        String unit = ((DistanceBufferOperator)filter).getDistanceUnits();
        String within = filter instanceof DWithin ? "TRUE" : "FALSE";
        this.out.write("SDO_WITHIN_DISTANCE(");
        property.accept((ExpressionVisitor)this, extraData);
        this.out.write(",");
        geometry.accept((ExpressionVisitor)this, extraData);
        if (unit != null && !"".equals(unit.trim())) {
            this.out.write(",'distance=" + distance + " unit=" + unit + "') = '" + within + "' ");
        } else {
            this.out.write(",'distance=" + distance + "') = '" + within + "' ");
        }
    }
}

