/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.el.CapturingELResolver;
import org.richfaces.el.ELContextWrapper;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.validator.BeanValidatorService;
import org.richfaces.validator.FacesBeanValidator;
import org.richfaces.validator.GraphValidatorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphValidator
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.GraphValidator";
    public static final String COMPONENT_FAMILY = "org.richfaces.GraphValidator";
    private static final Logger LOG = RichfacesLogger.COMPONENTS.getLogger();

    @Attribute
    public abstract Object getValue();

    public abstract void setValue(Object var1);

    @Attribute
    public abstract String getSummary();

    public abstract void setSummary(String var1);

    @Attribute
    public abstract Class<?>[] getGroups();

    public abstract void setGroups(Class<?>[] var1);

    @Attribute(defaultValue="org.richfaces.BeanValidator")
    public abstract String getType();

    public abstract void setType(String var1);

    public void processDecodes(FacesContext context) {
        Object value;
        GraphValidatorState validatorState = null;
        ValueExpression valueExpression = this.getValueExpression("value");
        if (null != valueExpression && null != (value = this.getValue()) && value instanceof Cloneable) {
            try {
                ELContext initialELContext = context.getELContext();
                CapturingELResolver capturingELResolver = new CapturingELResolver(initialELContext.getELResolver());
                Class type = valueExpression.getType((ELContext)new ELContextWrapper(initialELContext, (ELResolver)capturingELResolver));
                if (null != type) {
                    validatorState = new GraphValidatorState();
                    Method method = this.getCloneMethod(value.getClass());
                    if (!Modifier.isPublic(method.getModifiers())) {
                        method.setAccessible(true);
                    }
                    validatorState.setCloned(method.invoke(value, new Object[0]));
                    validatorState.setBase(capturingELResolver.getBase());
                    validatorState.setProperty(capturingELResolver.getProperty());
                    validatorState.setActive(true);
                    context.getExternalContext().getRequestMap().put(this.getStateId(context), validatorState);
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                throw new FacesException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                throw new FacesException((Throwable)e);
            }
        }
        super.processDecodes(context);
        if (null != validatorState) {
            validatorState.setActive(false);
        }
    }

    private Method getCloneMethod(Class<?> clazz) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (null != clazz.getSuperclass()) {
                return this.getCloneMethod(clazz.getSuperclass());
            }
            throw e;
        }
    }

    protected String getStateId(FacesContext context) {
        String stateId = "org.richfaces.GraphValidator:" + this.getClientId(context);
        return stateId;
    }

    protected GraphValidatorState getValidatorState(FacesContext context) {
        return (GraphValidatorState)context.getExternalContext().getRequestMap().get(this.getStateId(context));
    }

    public void processValidators(FacesContext context) {
        GraphValidatorState validatorState = this.getValidatorState(context);
        if (null != validatorState) {
            validatorState.setActive(true);
        }
        super.processValidators(context);
        if (null != validatorState) {
            validatorState.setActive(false);
            this.validateObject(context, validatorState.getCloned());
            context.getExternalContext().getRequestMap().remove(this.getStateId(context));
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        Object value = this.getValue();
        this.validateObject(context, value);
    }

    private void validateObject(FacesContext context, Object value) {
        BeanValidatorService validatorService;
        Collection messages;
        if (null != value && !(messages = (validatorService = (BeanValidatorService)ServiceTracker.getService(BeanValidatorService.class)).validateObject(context, value, (Class[])this.getGroups())).isEmpty()) {
            context.renderResponse();
            String clientId = this.getClientId(context);
            for (String msg : messages) {
                String summary = null != this.getSummary() ? this.getSummary() : msg;
                context.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, msg));
            }
        }
    }

    public Validator createChildrenValidator(FacesContext context) {
        FacesBeanValidator validator = (FacesBeanValidator)context.getApplication().createValidator(this.getType());
        validator.setSummary(this.getSummary());
        ValueExpression expression = this.getValueExpression("groups");
        if (null != expression) {
            validator.setGroups(expression);
        } else {
            validator.setGroups(this.getGroups());
        }
        return validator;
    }
}

