/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import javax.el.ValueExpression;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.component.AbstractDataScroller;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.taglib.MethodExpressionScrollListener;

public class DataScrollerHandler
extends ComponentHandler {
    private static final MetaRule PAGERULE = new MetaRule(){

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if ("page".equals(name)) {
                return new PageMapper(attribute);
            }
            return null;
        }
    };
    private static final MetaRule SCROLL_LISTENER_RULE = new MetaRule(){

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(AbstractDataScroller.class) && "scrollListener".equals(name)) {
                return new ScrollListenerMapper(attribute);
            }
            return null;
        }
    };

    public DataScrollerHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset ruleset = super.createMetaRuleset(type);
        ruleset.addRule(PAGERULE);
        ruleset.addRule(SCROLL_LISTENER_RULE);
        return ruleset;
    }

    private static final class PageMapper
    extends Metadata {
        private final TagAttribute page;

        public PageMapper(TagAttribute attribute) {
            this.page = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            AbstractDataScroller datascroller = (AbstractDataScroller)((Object)instance);
            ValueExpression ve = this.page.getValueExpression(ctx, Integer.TYPE);
            if (ve.isLiteralText()) {
                Integer value = (Integer)ve.getValue(ctx.getFacesContext().getELContext());
                datascroller.setPage(value);
            } else {
                datascroller.setValueExpression("page", ve);
            }
        }
    }

    private static final class ScrollListenerMapper
    extends Metadata {
        private static final Class[] SIGNATURE = new Class[]{DataScrollerEvent.class};
        private final TagAttribute attribute;

        public ScrollListenerMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((AbstractDataScroller)((Object)instance)).addScrollerListener(new MethodExpressionScrollListener(this.attribute.getMethodExpression(ctx, null, SIGNATURE)));
        }
    }
}

