/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.richfaces.component.AbstractSelectComponent;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.component.util.InputUtils;
import org.richfaces.component.util.SelectUtils;
import org.richfaces.renderkit.ClientSelectItem;
import org.richfaces.renderkit.ComponentAttribute;

public final class SelectHelper {
    public static final String OPTIONS_SHOWCONTROL = "showControl";
    public static final String OPTIONS_LIST_ITEMS = "items";
    public static final String OPTIONS_ENABLE_MANUAL_INPUT = "enableManualInput";
    public static final String OPTIONS_LIST_SELECT_FIRST = "selectFirst";
    public static final String OPTIONS_INPUT_DEFAULT_LABEL = "defaultLabel";
    public static final Map<String, ComponentAttribute> SELECT_LIST_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onclick").setEventNames("listclick").setComponentAttributeName("onlistclick"), new ComponentAttribute("ondblclick").setEventNames("listdblclick").setComponentAttributeName("onlistdblclick"), new ComponentAttribute("onmousedown").setEventNames("listmousedown").setComponentAttributeName("onlistmousedown"), new ComponentAttribute("onmouseup").setEventNames("listmouseup").setComponentAttributeName("onlistmouseup"), new ComponentAttribute("onmouseover").setEventNames("listmouseover").setComponentAttributeName("onlistmouseover"), new ComponentAttribute("onmousemove").setEventNames("listmousemove").setComponentAttributeName("onlistmousemove"), new ComponentAttribute("onmouseout").setEventNames("listmouseout").setComponentAttributeName("onlistmouseout"), new ComponentAttribute("onkeypress").setEventNames("listkeypress").setComponentAttributeName("onlistkeypress"), new ComponentAttribute("onkeydown").setEventNames("listkeydown").setComponentAttributeName("onlistkeydown"), new ComponentAttribute("onkeyup").setEventNames("listkeyup").setComponentAttributeName("onlistkeyup")));

    private SelectHelper() {
    }

    public static List<ClientSelectItem> getConvertedSelectItems(FacesContext facesContext, UIComponent component) {
        Iterator<SelectItem> selectItems = SelectUtils.getSelectItems(facesContext, component);
        ArrayList<ClientSelectItem> clientSelectItems = new ArrayList<ClientSelectItem>();
        while (selectItems.hasNext()) {
            SelectItem selectItem = selectItems.next();
            clientSelectItems.add(SelectHelper.generateClientSelectItem(facesContext, component, selectItem, 0, false));
        }
        return clientSelectItems;
    }

    public static ClientSelectItem generateClientSelectItem(FacesContext facesContext, UIComponent component, SelectItem selectItem, int sortOrder, boolean selected) {
        String convertedStringValue = InputUtils.getConvertedStringValue(facesContext, component, selectItem.getValue());
        String label = selectItem.getLabel();
        ClientSelectItem clientSelectItem = new ClientSelectItem(selectItem, convertedStringValue, label, sortOrder, selected);
        return clientSelectItem;
    }

    public static void encodeItems(FacesContext facesContext, UIComponent component, List<ClientSelectItem> clientSelectItems, String itemHtmlElement, String defaultItemCss) throws IOException {
        AbstractSelectComponent select = (AbstractSelectComponent)component;
        if (clientSelectItems != null && !clientSelectItems.isEmpty()) {
            ResponseWriter writer = facesContext.getResponseWriter();
            String clientId = component.getClientId(facesContext);
            int i = 0;
            for (ClientSelectItem clientSelectItem : clientSelectItems) {
                String itemClientId = clientId + "Item" + i++;
                clientSelectItem.setClientId(itemClientId);
                writer.startElement(itemHtmlElement, (UIComponent)select);
                writer.writeAttribute("id", (Object)itemClientId, null);
                writer.writeAttribute("class", (Object)HtmlUtil.concatClasses(defaultItemCss, select.getItemClass()), null);
                String label = clientSelectItem.getLabel();
                if (label != null && label.trim().length() > 0) {
                    writer.writeText((Object)label, null);
                } else {
                    writer.write("\u00a0");
                }
                writer.endElement(itemHtmlElement);
            }
        }
    }

    public static String getSelectInputLabel(FacesContext facesContext, UIComponent component) {
        AbstractSelectComponent select = (AbstractSelectComponent)component;
        Object value = select.getSubmittedValue();
        String label = null;
        if (value == null && (value = select.getValue()) != null) {
            Iterator<SelectItem> items = SelectUtils.getSelectItems(facesContext, component);
            while (items.hasNext()) {
                SelectItem item = items.next();
                if (!value.equals(item.getValue())) continue;
                label = item.getLabel();
            }
        }
        return label;
    }

    public static void addSelectCssToOptions(AbstractSelectComponent abstractSelect, Map<String, Object> options, String[] defaultCss) {
        String listCss;
        String selectItemCss;
        String itemCss = abstractSelect.getItemClass();
        if (itemCss != null && itemCss.trim().length() > 0) {
            options.put("itemCss", HtmlUtil.concatClasses(defaultCss[0], itemCss));
        }
        if ((selectItemCss = abstractSelect.getSelectItemClass()) != null && selectItemCss.trim().length() > 0) {
            options.put("selectItemCss", HtmlUtil.concatClasses(defaultCss[1], selectItemCss));
        }
        if ((listCss = abstractSelect.getListClass()) != null && listCss.trim().length() > 0) {
            options.put("listCss", HtmlUtil.concatClasses(defaultCss[2], listCss));
        }
    }
}

