/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProtectPointcutPostProcessor
implements BeanPostProcessor {
    private static final Log logger = LogFactory.getLog(ProtectPointcutPostProcessor.class);
    private final Map<String, List<ConfigAttribute>> pointcutMap = new LinkedHashMap<String, List<ConfigAttribute>>();
    private final MapBasedMethodSecurityMetadataSource mapBasedMethodSecurityMetadataSource;
    private final Set<PointcutExpression> pointCutExpressions = new LinkedHashSet<PointcutExpression>();
    private final PointcutParser parser;
    private final Set<String> processedBeans = new HashSet<String>();

    public ProtectPointcutPostProcessor(MapBasedMethodSecurityMetadataSource mapBasedMethodSecurityMetadataSource) {
        Assert.notNull((Object)mapBasedMethodSecurityMetadataSource, (String)"MapBasedMethodSecurityMetadataSource to populate is required");
        this.mapBasedMethodSecurityMetadataSource = mapBasedMethodSecurityMetadataSource;
        HashSet<PointcutPrimitive> supportedPrimitives = new HashSet<PointcutPrimitive>(3);
        supportedPrimitives.add(PointcutPrimitive.EXECUTION);
        supportedPrimitives.add(PointcutPrimitive.ARGS);
        supportedPrimitives.add(PointcutPrimitive.REFERENCE);
        this.parser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution(supportedPrimitives);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods;
        if (this.processedBeans.contains(beanName)) {
            return bean;
        }
        try {
            methods = bean.getClass().getMethods();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        block2: for (int i = 0; i < methods.length; ++i) {
            for (PointcutExpression expression : this.pointCutExpressions) {
                if (!this.attemptMatch(bean.getClass(), methods[i], expression, beanName)) continue;
                continue block2;
            }
        }
        this.processedBeans.add(beanName);
        return bean;
    }

    private boolean attemptMatch(Class<?> targetClass, Method method, PointcutExpression expression, String beanName) {
        boolean matches = expression.matchesMethodExecution(method).alwaysMatches();
        if (matches) {
            List<ConfigAttribute> attr = this.pointcutMap.get(expression.getPointcutExpression());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AspectJ pointcut expression '" + expression.getPointcutExpression() + "' matches target class '" + targetClass.getName() + "' (bean ID '" + beanName + "') for method '" + method + "'; registering security configuration attribute '" + attr + "'"));
            }
            this.mapBasedMethodSecurityMetadataSource.addSecureMethod(targetClass, method, attr);
        }
        return matches;
    }

    public void setPointcutMap(Map<String, List<ConfigAttribute>> map) {
        Assert.notEmpty(map);
        for (String expression : map.keySet()) {
            List<ConfigAttribute> value = map.get(expression);
            this.addPointcut(expression, value);
        }
    }

    private void addPointcut(String pointcutExpression, List<ConfigAttribute> definition) {
        Assert.hasText((String)pointcutExpression, (String)"An AspectJ pointcut expression is required");
        Assert.notNull(definition, (String)"A List of ConfigAttributes is required");
        pointcutExpression = this.replaceBooleanOperators(pointcutExpression);
        this.pointcutMap.put(pointcutExpression, definition);
        this.pointCutExpressions.add(this.parser.parsePointcutExpression(pointcutExpression));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AspectJ pointcut expression '" + pointcutExpression + "' registered for security configuration attribute '" + definition + "'"));
        }
    }

    private String replaceBooleanOperators(String pcExpr) {
        pcExpr = StringUtils.replace((String)pcExpr, (String)" and ", (String)" && ");
        pcExpr = StringUtils.replace((String)pcExpr, (String)" or ", (String)" || ");
        pcExpr = StringUtils.replace((String)pcExpr, (String)" not ", (String)" ! ");
        return pcExpr;
    }
}

