/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicExtractor<J>
implements ValueExtractor<J> {
    private static final Logger log = LoggerFactory.getLogger(BasicExtractor.class);
    private final JavaTypeDescriptor<J> javaDescriptor;
    private final SqlTypeDescriptor sqlDescriptor;

    public BasicExtractor(JavaTypeDescriptor<J> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        this.javaDescriptor = javaDescriptor;
        this.sqlDescriptor = sqlDescriptor;
    }

    public JavaTypeDescriptor<J> getJavaDescriptor() {
        return this.javaDescriptor;
    }

    public SqlTypeDescriptor getSqlDescriptor() {
        return this.sqlDescriptor;
    }

    @Override
    public J extract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
        J value = this.doExtract(rs, name, options);
        if (value == null || rs.wasNull()) {
            log.trace("found [null] as column [{}]", (Object)name);
            return null;
        }
        log.trace("found [{}] as column [{}]", (Object)this.getJavaDescriptor().extractLoggableRepresentation(value), (Object)name);
        return value;
    }

    protected abstract J doExtract(ResultSet var1, String var2, WrapperOptions var3) throws SQLException;
}

