/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.requestcycle.UserAction;
import net.fckeditor.requestcycle.UserPathBuilder;
import net.fckeditor.tool.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCycleHandler {
    private static final Logger logger;
    private static UserAction userAction;
    private static UserPathBuilder userPathBuilder;

    public static boolean isGetResourcesEnabled(HttpServletRequest request) {
        return userAction.isEnabledForFileBrowsing(request);
    }

    public static boolean isFileUploadEnabled(HttpServletRequest request) {
        return userAction.isEnabledForFileUpload(request);
    }

    public static boolean isCreateFolderEnabled(HttpServletRequest request) {
        return userAction.isCreateFolderEnabled(request);
    }

    public static String getUserFilesPath(HttpServletRequest request) {
        return userPathBuilder.getUserFilesPath(request);
    }

    public static String getUserFilesAbsolutePath(HttpServletRequest request) {
        return userPathBuilder.getUserFilesAbsolutePath(request);
    }

    static {
        Class<?> clazz;
        logger = LoggerFactory.getLogger((Class)RequestCycleHandler.class);
        userAction = null;
        userPathBuilder = null;
        String className = PropertiesLoader.getUserActionImpl();
        if (Utils.isEmpty(className)) {
            logger.error("Empty UserAction implementation class name provided");
        } else {
            try {
                clazz = Class.forName(className);
                userAction = (UserAction)clazz.newInstance();
                logger.info("UserAction initialized to {}", (Object)className);
            }
            catch (Throwable e) {
                logger.error("UserAction implementation {} could not be instantiated", (Object)className);
                throw new RuntimeException("UserAction implementation " + className + " could not be instantiated", e);
            }
        }
        className = PropertiesLoader.getUserPathBuilderImpl();
        if (Utils.isEmpty(className)) {
            logger.error("Empty UserPathBuilder implementation class name provided");
        } else {
            try {
                clazz = Class.forName(className);
                userPathBuilder = (UserPathBuilder)clazz.newInstance();
                logger.info("UserPathBuilder initialized to {}", (Object)className);
            }
            catch (Throwable e) {
                logger.error("UserPathBuilder implementation {} could not be instantiated", (Object)className);
                throw new RuntimeException("UserPathBuilder implementation " + className + " could not be instantiated", e);
            }
        }
    }
}

