/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.response;

import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.fckeditor.handlers.Command;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.localization.LocalizedMessages;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.tool.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetResponse {
    protected Document document;
    protected Element errorElement;
    protected Element foldersElement;
    protected Element filesElement;
    public static final int EN_OK = 0;
    public static final int EN_CUSTOM_ERROR = 1;
    public static final int EN_FOLDER_ALREADY_EXISTS_ERROR = 101;
    public static final int EN_INVALID_NEW_FOLDER_NAME_ERROR = 102;
    public static final int EN_CREATE_FOLDER_SECURITY_ERROR = 103;
    public static final int EN_UKNOWN_CREATE_FOLDER_ERROR = 110;

    public GetResponse(int number, String message) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element root = this.document.createElement("Connector");
        this.document.appendChild(root);
        this.setError(number, message);
    }

    public GetResponse(Command command, ResourceType type, String currentFolder, String constructedUrl) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element root = this.document.createElement("Connector");
        this.document.appendChild(root);
        root.setAttribute("command", command.getName());
        root.setAttribute("resourceType", type.getName());
        Element currentFolderElement = this.document.createElement("CurrentFolder");
        currentFolderElement.setAttribute("path", currentFolder);
        currentFolderElement.setAttribute("url", constructedUrl);
        root.appendChild(currentFolderElement);
    }

    public GetResponse(int number) {
        this(number, null);
    }

    public void setError(int number, String message) {
        if (this.errorElement == null) {
            this.errorElement = this.document.createElement("Error");
            this.document.getDocumentElement().appendChild(this.errorElement);
        }
        this.errorElement.setAttribute("number", String.valueOf(number));
        if (Utils.isNotEmpty(message)) {
            this.errorElement.setAttribute("text", message);
        }
    }

    public void setError(int number) {
        this.setError(number, null);
    }

    public void setFolders(List<String> folders) {
        if (this.foldersElement != null) {
            Element parent = (Element)this.foldersElement.getParentNode();
            parent.removeChild(this.foldersElement);
        }
        this.foldersElement = this.document.createElement("Folders");
        this.document.getDocumentElement().appendChild(this.foldersElement);
        for (String folder : folders) {
            Element folderElement = this.document.createElement("Folder");
            folderElement.setAttribute("name", folder);
            this.foldersElement.appendChild(folderElement);
        }
    }

    public void setFiles(List<Map<String, Object>> files) {
        if (this.filesElement != null) {
            Element parent = (Element)this.filesElement.getParentNode();
            parent.removeChild(this.filesElement);
        }
        this.filesElement = this.document.createElement("Files");
        this.document.getDocumentElement().appendChild(this.filesElement);
        long length = 1L;
        for (Map<String, Object> file : files) {
            Element fileElement = this.document.createElement("File");
            fileElement.setAttribute("name", (String)file.get("name"));
            long tempLength = ((Number)file.get("size")).longValue();
            if (tempLength > 1024L) {
                length = tempLength / 1024L;
            }
            fileElement.setAttribute("size", String.valueOf(length));
            this.filesElement.appendChild(fileElement);
        }
    }

    public String toString() {
        this.document.getDocumentElement().normalize();
        TransformerFactory factory = TransformerFactory.newInstance();
        StringWriter sw = new StringWriter();
        try {
            Transformer transformer = factory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public static GetResponse getOK() {
        return new GetResponse(0);
    }

    public static GetResponse getInvalidCommandError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(1, lm.getInvalidCommandSpecified());
    }

    public static GetResponse getInvalidResourceTypeError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(1, lm.getInvalidResouceTypeSpecified());
    }

    public static GetResponse getInvalidCurrentFolderError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(1, lm.getInvalidCurrentFolderSpecified());
    }

    public static GetResponse getGetResourcesDisabledError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(1, lm.getGetResourcesDisabled());
    }

    public static GetResponse getGetResourcesReadError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(1, lm.getGetResourcesReadError());
    }

    public static GetResponse getCreateFolderDisabledError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(1, lm.getCreateFolderDisabled());
    }

    public static GetResponse getInvalidNewFolderNameError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(102, lm.getInvalidNewFolderNameSpecified());
    }

    public static GetResponse getFolderAlreadyExistsError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(101, lm.getFolderAlreadyExistsError());
    }

    public static GetResponse getCreateFolderWriteError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new GetResponse(110, lm.getCreateFolderWriteError());
    }
}

