/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class GenerationStamp
implements Comparable<GenerationStamp> {
    public static final long FIRST_VALID_STAMP = 1000L;
    public static final long GRANDFATHER_GENERATION_STAMP = 0L;
    private AtomicLong genstamp = new AtomicLong();

    public GenerationStamp() {
        this(1000L);
    }

    GenerationStamp(long stamp) {
        this.genstamp.set(stamp);
    }

    public long getStamp() {
        return this.genstamp.get();
    }

    public void setStamp(long stamp) {
        this.genstamp.set(stamp);
    }

    public long nextStamp() {
        return this.genstamp.incrementAndGet();
    }

    @Override
    public int compareTo(GenerationStamp that) {
        long stamp2;
        long stamp1 = this.genstamp.get();
        return stamp1 < (stamp2 = that.genstamp.get()) ? -1 : (stamp1 > stamp2 ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenerationStamp)) {
            return false;
        }
        return this.compareTo((GenerationStamp)o) == 0;
    }

    public int hashCode() {
        long stamp = this.genstamp.get();
        return (int)(stamp ^ stamp >>> 32);
    }
}

