/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.checkstyle.AbstractCheckstyleReport;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;

public class CheckstyleReport
extends AbstractCheckstyleReport {
    private static final Map<String, String> FORMAT_TO_CONFIG_LOCATION;
    private String includes;
    private String excludes;
    private String configLocation;
    private String format;
    private String propertiesLocation;
    private File propertiesFile;
    private URL propertiesURL;
    private String propertyExpansion;
    private String headerLocation;
    private File headerFile;
    private String cacheFile;
    private String suppressionsLocation;
    private String suppressionsFileExpression;
    private String suppressionsFile;
    private String packageNamesLocation;
    private String packageNamesFile;
    private boolean failsOnError;
    private File sourceDirectory;
    private File testSourceDirectory;
    private boolean includeTestSourceDirectory;
    private boolean consoleOutput;
    private String encoding;

    protected MavenProject getProject() {
        return this.project;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        this.mergeDeprecatedInfo();
        super.executeReport(locale);
    }

    protected CheckstyleExecutorRequest createRequest() throws MavenReportException {
        CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
        request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setLog(this.getLog()).setProject(this.project).setSourceDirectory(this.sourceDirectory).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectory(this.testSourceDirectory).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
        return request;
    }

    public String getOutputName() {
        return "checkstyle";
    }

    public boolean canGenerateReport() {
        return !this.skip && (this.sourceDirectory.exists() || this.includeTestSourceDirectory && this.testSourceDirectory.exists());
    }

    private void mergeDeprecatedInfo() {
        File defaultHeaderFile;
        if ("config/sun_checks.xml".equals(this.configLocation) && !"sun".equals(this.format)) {
            this.configLocation = FORMAT_TO_CONFIG_LOCATION.get(this.format);
        }
        if (StringUtils.isEmpty((String)this.propertiesLocation)) {
            if (this.propertiesFile != null) {
                this.propertiesLocation = this.propertiesFile.getPath();
            } else if (this.propertiesURL != null) {
                this.propertiesLocation = this.propertiesURL.toExternalForm();
            }
        }
        if ("LICENSE.txt".equals(this.headerLocation) && !(defaultHeaderFile = new File(this.project.getBasedir(), "LICENSE.txt")).equals(this.headerFile)) {
            this.headerLocation = this.headerFile.getPath();
        }
        if (StringUtils.isEmpty((String)this.suppressionsLocation)) {
            this.suppressionsLocation = this.suppressionsFile;
        }
        if (StringUtils.isEmpty((String)this.packageNamesLocation)) {
            this.packageNamesLocation = this.packageNamesFile;
        }
    }

    static {
        HashMap<String, String> fmt2Cfg = new HashMap<String, String>();
        fmt2Cfg.put("sun", "config/sun_checks.xml");
        fmt2Cfg.put("turbine", "config/turbine_checks.xml");
        fmt2Cfg.put("avalon", "config/avalon_checks.xml");
        fmt2Cfg.put("maven", "config/maven_checks.xml");
        FORMAT_TO_CONFIG_LOCATION = Collections.unmodifiableMap(fmt2Cfg);
    }
}

