/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.xml;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bedework.util.misc.Logged;
import org.bedework.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FromXml
extends Logged {
    public Object fromXml(InputStream is, Class cl) throws SAXException {
        try {
            Document doc = this.parseXml(is);
            Object o = this.fromClass(cl);
            if (o == null) {
                return null;
            }
            for (Element el : XmlUtil.getElementsArray(doc.getDocumentElement())) {
                this.populate(el, o, null, null);
            }
            return o;
        }
        catch (SAXException se) {
            if (this.debug) {
                this.error(se);
            }
            throw se;
        }
        catch (Throwable t) {
            if (this.debug) {
                this.error(t);
            }
            throw new SAXException(t.getMessage());
        }
    }

    public Object fromXml(Element rootEl, Class cl) throws SAXException {
        try {
            Object o = this.fromClass(cl);
            if (o == null) {
                return null;
            }
            for (Element el : XmlUtil.getElementsArray(rootEl)) {
                this.populate(el, o, null, null);
            }
            return o;
        }
        catch (SAXException se) {
            if (this.debug) {
                this.error(se);
            }
            throw se;
        }
        catch (Throwable t) {
            if (this.debug) {
                this.error(t);
            }
            throw new SAXException(t.getMessage());
        }
    }

    public Document parseXml(InputStream is) throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(is));
        if (doc == null) {
            return null;
        }
        return doc;
    }

    private Object fromClass(Class cl) throws Throwable {
        if (cl == null) {
            this.error("Must supply a class or have type attribute");
            return null;
        }
        return cl.newInstance();
    }

    private void populate(Element subroot, Object o, Collection<Object> col, Class cl) throws Throwable {
        Object val;
        Class<?> elClass;
        String name = subroot.getNodeName();
        Method meth = null;
        if (col == null) {
            meth = this.findSetter(o, name);
            if (meth == null) {
                this.error("No setter for " + name);
                return;
            }
            Class<?>[] parClasses = meth.getParameterTypes();
            if (parClasses.length != 1) {
                this.error("Invalid setter method " + name);
                throw new SAXException("Invalid setter method " + name);
            }
            elClass = parClasses[0];
        } else {
            elClass = cl;
        }
        if (!XmlUtil.hasChildren(subroot)) {
            val = FromXml.simpleValue(elClass, subroot);
            if (val == null) {
                this.error("Unsupported par class " + elClass + " for field " + name);
                throw new SAXException("Unsupported par class " + elClass + " for field " + name);
            }
            FromXml.assign(val, col, o, meth);
            return;
        }
        if (Collection.class.isAssignableFrom(elClass)) {
            TreeSet<Object> colVal;
            if (elClass.getName().equals("java.util.Set")) {
                colVal = new TreeSet();
            } else if (elClass.getName().equals("java.util.List")) {
                colVal = new ArrayList();
            } else {
                this.error("Unsupported element class " + elClass + " for field " + name);
                return;
            }
            FromXml.assign(colVal, col, o, meth);
            Type[] gpts = meth.getGenericParameterTypes();
            if (gpts.length != 1) {
                this.error("Unsupported type " + elClass + " with name " + name);
                return;
            }
            Type gpt = gpts[0];
            if (!(gpt instanceof ParameterizedType)) {
                this.error("Unsupported type " + elClass + " with name " + name);
                return;
            }
            ParameterizedType aType = (ParameterizedType)gpt;
            Type[] parameterArgTypes = aType.getActualTypeArguments();
            if (parameterArgTypes.length != 1) {
                this.error("Unsupported type " + elClass + " with name " + name);
                return;
            }
            Type parameterArgType = parameterArgTypes[0];
            Class colElType = (Class)parameterArgType;
            for (Element el : XmlUtil.getElementsArray(subroot)) {
                this.populate(el, o, colVal, colElType);
            }
            return;
        }
        val = this.fromClass(elClass);
        FromXml.assign(val, col, o, meth);
        for (Element el : XmlUtil.getElementsArray(subroot)) {
            this.populate(el, val, null, null);
        }
    }

    private Method findSetter(Object val, String name) throws Throwable {
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] meths = val.getClass().getMethods();
        Method meth = null;
        for (Method m : meths) {
            if (!m.getName().equals(methodName)) continue;
            if (meth != null) {
                throw new SAXException("Multiple setters for field " + name);
            }
            meth = m;
        }
        if (meth == null) {
            this.error("No setter method for property " + name + " for class " + val.getClass().getName());
            return null;
        }
        return meth;
    }

    private static void assign(Object val, Collection<Object> col, Object o, Method meth) throws Throwable {
        if (col != null) {
            col.add(val);
        } else {
            Object[] pars = new Object[]{val};
            meth.invoke(o, pars);
        }
    }

    private static Object simpleValue(Class cl, Element el) throws Throwable {
        if (!XmlUtil.hasChildren(el)) {
            String ndval = XmlUtil.getElementContent(el);
            if (cl.getName().equals("java.lang.String")) {
                return ndval;
            }
            if (cl.getName().equals("int") || cl.getName().equals("java.lang.Integer")) {
                return Integer.valueOf(ndval);
            }
            if (cl.getName().equals("long") || cl.getName().equals("java.lang.Long")) {
                return Long.valueOf(ndval);
            }
            if (cl.getName().equals("boolean") || cl.getName().equals("java.lang.Boolean")) {
                return Boolean.valueOf(ndval);
            }
            return null;
        }
        return null;
    }
}

