/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.bedework.util.xml.EntityMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public final class XmlUtil
implements Serializable {
    public static final int xmlOk = 0;
    public static final int xmlMissing = 1;
    public static final int xmlUntidy = 2;
    public static final int xmlError = 3;
    public static final int xmlTidyNull = 4;
    public static final int xmlNotXml = 5;
    public static final int xmlTidyException = 5;

    public static void tidyString(String id, String val, CheckStringResult crs) {
        crs.errStr = null;
        crs.tidyState = 0;
        crs.newContent = null;
        if (val == null || val.length() == 0) {
            return;
        }
        StringWriter errStrw = new StringWriter();
        PrintWriter err = new PrintWriter(errStrw);
        try {
            crs.newContent = XmlUtil.tidyXML(id, val, err);
        }
        catch (Exception e) {
            crs.tidyState = 5;
            e.printStackTrace(err);
            return;
        }
        crs.errStr = errStrw.getBuffer().toString();
        if (crs.errStr != null && crs.errStr.length() != 0) {
            crs.tidyState = 3;
            return;
        }
        if (crs.newContent == null || crs.newContent.length() == 0) {
            crs.newContent = null;
            return;
        }
        try {
            crs.newContent = EntityMap.makeNumeric(crs.newContent, true);
        }
        catch (Throwable t) {
            errStrw.write("Tidy exception " + t.getMessage());
            crs.tidyState = 3;
        }
        if (crs.tidyState == 3) {
            crs.errStr = errStrw.getBuffer().toString();
        }
    }

    public static void checkString(String id, String val, CheckStringResult crs, boolean emptyOk) {
        XmlUtil.tidyString(id, val, crs);
        if (crs.tidyState == 0 && crs.newContent == null) {
            if (!emptyOk) {
                crs.tidyState = 4;
            }
            return;
        }
        if (crs.tidyState == 3) {
            return;
        }
        if (!XmlUtil.strip(val).equals(XmlUtil.strip(crs.newContent))) {
            crs.tidyState = 2;
            return;
        }
    }

    private static String strip(String strVal) {
        StringBuffer val = new StringBuffer(strVal);
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) == '\r') {
                val.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return val.toString();
    }

    public static String tidyXML(String id, String val, PrintWriter err) throws Exception {
        if (val == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(val.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Tidy tidy = new Tidy();
            tidy.setAltText("please supply an alt tag");
            tidy.setDropEmptyParas(true);
            tidy.setDropFontTags(true);
            tidy.setEncloseBlockText(false);
            tidy.setEncloseText(true);
            tidy.setFixBackslash(true);
            tidy.setFixComments(true);
            tidy.setIndentContent(true);
            tidy.setIndentAttributes(true);
            tidy.setInputStreamName(id);
            tidy.setLogicalEmphasis(true);
            tidy.setNumEntities(false);
            tidy.setQuiet(true);
            tidy.setQuoteAmpersand(true);
            tidy.setShowWarnings(false);
            tidy.setSmartIndent(true);
            tidy.setSpaces(2);
            tidy.setTabsize(2);
            tidy.setWord2000(false);
            tidy.setXHTML(true);
            tidy.setMakeClean(false);
            tidy.setCharEncoding(3);
            tidy.setErrout(err);
            tidy.parse((InputStream)in, (OutputStream)out);
            String res = out.toString();
            if (res.length() == 1 && res.charAt(0) == '\n') {
                err.println("Tidy for " + id + " results in empty string");
                res = null;
            }
            return res;
        }
        catch (Exception e) {
            throw new Exception("Unable to tidy document");
        }
    }

    public static Node getOneTaggedNode(Node el, String name) throws SAXException {
        if (!el.hasChildNodes()) {
            return null;
        }
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!name.equals(n.getNodeName())) continue;
            return n;
        }
        return null;
    }

    public static String getOneNodeVal(Node el, String name) throws SAXException {
        if (!el.hasChildNodes()) {
            return null;
        }
        NodeList children = el.getChildNodes();
        if (children.getLength() > 1) {
            throw new SAXException("Multiple property values: " + name);
        }
        Node child = children.item(0);
        return child.getNodeValue();
    }

    public static String getOneNodeVal(Node el) throws SAXException {
        return XmlUtil.getOneNodeVal(el, el.getNodeName());
    }

    public static String getReqOneNodeVal(Node el, String name) throws SAXException {
        String str = XmlUtil.getOneNodeVal(el, name);
        if (str == null || str.length() == 0) {
            throw new SAXException("Missing property value: " + name);
        }
        return str;
    }

    public static String getReqOneNodeVal(Node el) throws SAXException {
        return XmlUtil.getReqOneNodeVal(el, el.getNodeName());
    }

    public static String getAttrVal(Element el, String name) throws SAXException {
        Attr at = el.getAttributeNode(name);
        if (at == null) {
            return null;
        }
        return at.getValue();
    }

    public static String getReqAttrVal(Element el, String name) throws SAXException {
        String str = XmlUtil.getAttrVal(el, name);
        if (str == null || str.length() == 0) {
            throw new SAXException("Missing attribute value: " + name);
        }
        return str;
    }

    public static String getAttrVal(NamedNodeMap nnm, String name) {
        Node nmAttr = nnm.getNamedItem(name);
        if (nmAttr == null || XmlUtil.absent(nmAttr.getNodeValue())) {
            return null;
        }
        return nmAttr.getNodeValue();
    }

    public static Boolean getYesNoAttrVal(NamedNodeMap nnm, String name) throws SAXException {
        String val = XmlUtil.getAttrVal(nnm, name);
        if (val == null) {
            return null;
        }
        if (!"yes".equals(val) && !"no".equals(val)) {
            throw new SAXException("Invalid attribute value: " + val);
        }
        return new Boolean("yes".equals(val));
    }

    public static int numAttrs(Node nd) {
        NamedNodeMap nnm = nd.getAttributes();
        if (nnm == null) {
            return 0;
        }
        return nnm.getLength();
    }

    public static List<Element> getElements(Node nd) throws SAXException {
        ArrayList<Element> al = new ArrayList<Element>();
        NodeList children = nd.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curnode = children.item(i);
            if (curnode.getNodeType() == 3) {
                String val = curnode.getNodeValue();
                if (val == null) continue;
                for (int vi = 0; vi < val.length(); ++vi) {
                    if (Character.isWhitespace(val.charAt(vi))) continue;
                    throw new SAXException("Non-whitespace text in element body for " + nd.getLocalName() + "\n text=" + val);
                }
                continue;
            }
            if (curnode.getNodeType() == 8) continue;
            if (curnode.getNodeType() == 1) {
                al.add((Element)curnode);
                continue;
            }
            throw new SAXException("Unexpected child node " + curnode.getLocalName() + " for " + nd.getLocalName());
        }
        return al;
    }

    public static String getElementContent(Element el, boolean trim) throws SAXException {
        StringBuilder sb = new StringBuilder();
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curnode = children.item(i);
            if (curnode.getNodeType() == 3) {
                sb.append(curnode.getNodeValue());
                continue;
            }
            if (curnode.getNodeType() == 4) {
                sb.append(curnode.getNodeValue());
                continue;
            }
            if (curnode.getNodeType() == 8) continue;
            throw new SAXException("Unexpected child node " + curnode.getLocalName() + " for " + el.getLocalName());
        }
        if (!trim) {
            return sb.toString();
        }
        return sb.toString().trim();
    }

    public static void setElementContent(Node n, String s) throws SAXException {
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curnode = children.item(i);
            n.removeChild(curnode);
        }
        Document d = n.getOwnerDocument();
        Text textNode = d.createTextNode(s);
        n.appendChild(textNode);
    }

    public static String getElementContent(Element el) throws SAXException {
        return XmlUtil.getElementContent(el, true);
    }

    public static boolean hasContent(Element el) throws SAXException {
        String s = XmlUtil.getElementContent(el);
        return s != null && s.length() > 0;
    }

    public static boolean hasChildren(Element el) throws SAXException {
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curnode = children.item(i);
            short ntype = curnode.getNodeType();
            if (ntype == 3 || ntype == 4 || ntype == 8) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Element el) throws SAXException {
        return !XmlUtil.hasChildren(el) && !XmlUtil.hasContent(el);
    }

    public static Element[] getElementsArray(Node nd) throws SAXException {
        List<Element> al = XmlUtil.getElements(nd);
        return al.toArray(new Element[al.size()]);
    }

    public static boolean nodeMatches(Node nd, QName tag) {
        if (tag == null) {
            return false;
        }
        String ns = nd.getNamespaceURI();
        if (ns == null ? tag.getNamespaceURI() != null && !"".equals(tag.getNamespaceURI()) : !ns.equals(tag.getNamespaceURI())) {
            return false;
        }
        String ln = nd.getLocalName();
        return !(ln == null ? tag.getLocalPart() != null : !ln.equals(tag.getLocalPart()));
    }

    public static QName fromNode(Node nd) {
        String ns = nd.getNamespaceURI();
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, nd.getLocalName());
    }

    public static Element getOnlyElement(Node nd) throws SAXException {
        Element[] els = XmlUtil.getElementsArray(nd);
        if (els.length != 1) {
            throw new SAXException("Expected exactly one child node for " + nd.getLocalName());
        }
        return els[0];
    }

    private static boolean absent(String val) {
        return val == null || val.length() == 0;
    }

    public static class CheckStringResult {
        public String errStr;
        public int tidyState;
        public String newContent;
    }
}

