/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:jaxb2-maven-plugin:1.3.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven JAXB 2.1 Plugin", 0);
        this.append(sb, "JAXB2 compiler plugin used to create object graph from XSDs based on the JAXB 2.1 implementation.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jaxb2:help", 0);
            this.append(sb, "Display help information on jaxb2-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jaxb2:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "schemagen".equals(this.goal)) {
            this.append(sb, "jaxb2:schemagen", 0);
            this.append(sb, "Creates XML Schema file(s) for sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclusion filters for the generator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of inclusion filters for the generator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-resources/schemagen)", 2);
                this.append(sb, "The working directory to place processor and javac generated class files.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3);
                this.append(sb, "Expression: ${lastModGranularityMs}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "testSchemagen".equals(this.goal)) {
            this.append(sb, "jaxb2:testSchemagen", 0);
            this.append(sb, "Creates XML Schema file(s) for test sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclusion filters for the generator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of inclusion filters for the generator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-test-resources/schemagen)", 2);
                this.append(sb, "The working directory to place processor and javac generated class files.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3);
                this.append(sb, "Expression: ${lastModGranularityMs}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "testXjc".equals(this.goal)) {
            this.append(sb, "jaxb2:testXjc", 0);
            this.append(sb, "Generates Java test sources from XML Schema(s) and binding file(s) using the JAXB Binding Compiler (XJC).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Space separated string of extra arguments, for instance -Xfluent-api -episode somefile; These will be passed on to XJC as '-Xfluent-api' '-episode' 'somefile' options.", 3);
                this.append(sb, "Expression: ${xjc.arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindingDirectory (Default: ${basedir}/src/test/xjb)", 2);
                this.append(sb, "The directory for JAXB binding files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindingFiles", 2);
                this.append(sb, "List of files to use for bindings, comma delimited. If none, then all xjb files are used in the bindingDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "catalog", 2);
                this.append(sb, "Catalog file to resolve external entity references support TR9401, XCatalog, and OASIS XML Catalog format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clearOutputDir (Default: true)", 2);
                this.append(sb, "Clears the output directory on each run. Defaults to 'true' but if false, will not clear the directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dtd (Default: false)", 2);
                this.append(sb, "Treat input schemas as XML DTD (experimental, unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "explicitAnnotation (Default: false)", 2);
                this.append(sb, "Allow generation of explicit annotations that are needed for JAXB2 to work on RetroTranslator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extension (Default: false)", 2);
                this.append(sb, "Allow to use the JAXB Vendor Extensions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnNoSchemas (Default: true)", 2);
                this.append(sb, "Fails the mojo if no schemas are found.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedResourcesDirectory", 2);
                this.append(sb, "The optional directory where generated resources can be placed, generated by addons/plugins.", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpproxy", 2);
                this.append(sb, "Set HTTP/HTTPS proxy. Format is [user[:password]@]proxyHost[:proxyPort]", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSchemasOutputPath", 2);
                this.append(sb, "The output path to include in your jar/war/etc if you wish to include your schemas in your artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "npa (Default: false)", 2);
                this.append(sb, "Suppress generation of package level annotations (package-info.java).", 3);
                this.append(sb, "", 0);
                this.append(sb, "nv (Default: false)", 2);
                this.append(sb, "Do not perform strict validation of the input schema(s).", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-test-sources/jaxb)", 2);
                this.append(sb, "The working directory where the generated Java test source files are created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageName", 2);
                this.append(sb, "The package in which the source files will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Suppress compiler output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "readOnly (Default: false)", 2);
                this.append(sb, "Generated files will be in read-only mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxng (Default: false)", 2);
                this.append(sb, "Treat input schemas as RELAX NG (experimental, unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxngCompact (Default: false)", 2);
                this.append(sb, "Treat input as RELAX NG compact syntax (experimental,unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaDirectory (Default: ${basedir}/src/test/xsd)", 2);
                this.append(sb, "The directory for XML Schema files (XSDs).", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaFiles", 2);
                this.append(sb, "List of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory. Note: you can only use either the 'schemaFiles' or the 'schemaListFileName' option (you may not use both at once!).", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaListFileName", 2);
                this.append(sb, "A filename containing the list of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory. Note: you can only use either the 'schemaFiles' or the 'schemaListFileName' option (you may not use both at once!).", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleFile (Default: ${project.build.directory}/jaxb2/.testXjcStaleFlag)", 2);
                this.append(sb, "The location of the flag file used to determine if the output is stale.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "Avoid generating code that relies on any current JAXB 2.x features. This will allow the generated code to run with earlier JAXB 2.x runtime.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Be extra verbose.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wsdl (Default: false)", 2);
                this.append(sb, "Treat input as WSDL and compile schemas inside it (experimental,unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlschema (Default: true)", 2);
                this.append(sb, "Treat input as W3C XML Schema (default).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xjc".equals(this.goal)) {
            this.append(sb, "jaxb2:xjc", 0);
            this.append(sb, "Generates Java sources from XML Schema(s) and binding file(s) using the JAXB Binding Compiler (XJC).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Space separated string of extra arguments, for instance -Xfluent-api -episode somefile; These will be passed on to XJC as '-Xfluent-api' '-episode' 'somefile' options.", 3);
                this.append(sb, "Expression: ${xjc.arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindingDirectory (Default: ${basedir}/src/main/xjb)", 2);
                this.append(sb, "The directory for JAXB binding files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindingFiles", 2);
                this.append(sb, "List of files to use for bindings, comma delimited. If none, then all xjb files are used in the bindingDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "catalog", 2);
                this.append(sb, "Catalog file to resolve external entity references support TR9401, XCatalog, and OASIS XML Catalog format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clearOutputDir (Default: true)", 2);
                this.append(sb, "Clears the output directory on each run. Defaults to 'true' but if false, will not clear the directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dtd (Default: false)", 2);
                this.append(sb, "Treat input schemas as XML DTD (experimental, unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "explicitAnnotation (Default: false)", 2);
                this.append(sb, "Allow generation of explicit annotations that are needed for JAXB2 to work on RetroTranslator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extension (Default: false)", 2);
                this.append(sb, "Allow to use the JAXB Vendor Extensions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnNoSchemas (Default: true)", 2);
                this.append(sb, "Fails the mojo if no schemas are found.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedResourcesDirectory", 2);
                this.append(sb, "The optional directory where generated resources can be placed, generated by addons/plugins.", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpproxy", 2);
                this.append(sb, "Set HTTP/HTTPS proxy. Format is [user[:password]@]proxyHost[:proxyPort]", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSchemasOutputPath", 2);
                this.append(sb, "The output path to include in your jar/war/etc if you wish to include your schemas in your artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "npa (Default: false)", 2);
                this.append(sb, "Suppress generation of package level annotations (package-info.java).", 3);
                this.append(sb, "", 0);
                this.append(sb, "nv (Default: false)", 2);
                this.append(sb, "Do not perform strict validation of the input schema(s).", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/jaxb)", 2);
                this.append(sb, "The working directory where the generated Java source files are created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageName", 2);
                this.append(sb, "The package in which the source files will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Suppress compiler output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "readOnly (Default: false)", 2);
                this.append(sb, "Generated files will be in read-only mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxng (Default: false)", 2);
                this.append(sb, "Treat input schemas as RELAX NG (experimental, unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxngCompact (Default: false)", 2);
                this.append(sb, "Treat input as RELAX NG compact syntax (experimental,unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaDirectory (Default: ${basedir}/src/main/xsd)", 2);
                this.append(sb, "The directory for XML Schema files (XSDs).", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaFiles", 2);
                this.append(sb, "List of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory. Note: you can only use either the 'schemaFiles' or the 'schemaListFileName' option (you may not use both at once!).", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaListFileName", 2);
                this.append(sb, "A filename containing the list of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory. Note: you can only use either the 'schemaFiles' or the 'schemaListFileName' option (you may not use both at once!).", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleFile (Default: ${project.build.directory}/jaxb2/.xjcStaleFlag)", 2);
                this.append(sb, "The location of the flag file used to determine if the output is stale.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "Avoid generating code that relies on any current JAXB 2.x features. This will allow the generated code to run with earlier JAXB 2.x runtime.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Be extra verbose.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wsdl (Default: false)", 2);
                this.append(sb, "Treat input as WSDL and compile schemas inside it (experimental,unsupported).", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlschema (Default: true)", 2);
                this.append(sb, "Treat input as W3C XML Schema (default).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

