/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

class SpringConfiguredBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String BEAN_CONFIGURER_CLASS_NAME = "org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect";
    private boolean registered;

    SpringConfiguredBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (!this.registered) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SpringConfiguredBeanDefinitionParser.getBeanConfigurerClass(), "aspectOf");
            builder.setSource(parserContext.extractSource(element));
            BeanDefinitionReaderUtils.registerWithGeneratedName(builder.getBeanDefinition(), parserContext.getRegistry());
            this.registered = true;
        }
        return null;
    }

    private static Class getBeanConfigurerClass() throws IllegalStateException {
        try {
            return ClassUtils.forName(BEAN_CONFIGURER_CLASS_NAME);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to load aspect class [org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect]: cannot use @Configurable. Root cause: " + ex);
        }
    }
}

