/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.TimerTask;
import org.springframework.scheduling.timer.DelegatingTimerTask;

public class ScheduledTimerTask {
    private TimerTask timerTask;
    private long delay = 0L;
    private long period = 0L;
    private boolean fixedRate = false;

    public ScheduledTimerTask() {
    }

    public ScheduledTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public ScheduledTimerTask(TimerTask timerTask, long delay) {
        this.timerTask = timerTask;
        this.delay = delay;
    }

    public ScheduledTimerTask(TimerTask timerTask, long delay, long period, boolean fixedRate) {
        this.timerTask = timerTask;
        this.delay = delay;
        this.period = period;
        this.fixedRate = fixedRate;
    }

    public ScheduledTimerTask(Runnable timerTask) {
        this.setRunnable(timerTask);
    }

    public ScheduledTimerTask(Runnable timerTask, long delay) {
        this.setRunnable(timerTask);
        this.delay = delay;
    }

    public ScheduledTimerTask(Runnable timerTask, long delay, long period, boolean fixedRate) {
        this.setRunnable(timerTask);
        this.delay = delay;
        this.period = period;
        this.fixedRate = fixedRate;
    }

    public void setRunnable(Runnable timerTask) {
        this.timerTask = new DelegatingTimerTask(timerTask);
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public boolean isOneTimeTask() {
        return this.period < 1L;
    }
}

