/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.ObjectUtils;

public abstract class CollectionUtils {
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean containsInstance(Collection collection, Object element) {
        if (collection != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                Object candidate = it.next();
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Iterator iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasUniqueObject(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static Object findValueOfType(Collection collection, Class type) throws IllegalArgumentException {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class typeToUse = type != null ? type : (class$java$lang$Object == null ? (class$java$lang$Object = CollectionUtils.class$("java.lang.Object")) : class$java$lang$Object);
        Object value = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!typeToUse.isInstance(obj)) continue;
            if (value != null) {
                throw new IllegalArgumentException("More than one value of type [" + typeToUse.getName() + "] found");
            }
            value = obj;
        }
        return value;
    }

    public static Object findValueOfType(Collection collection, Class[] types) throws IllegalArgumentException {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            Object value = CollectionUtils.findValueOfType(collection, types[i]);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static void mergePropertiesIntoMap(Properties props, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                map.put(key, props.getProperty(key));
            }
        }
    }

    public static boolean containsAny(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            if (!source.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            Object candidate = it.next();
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

